var zjJSBridge = function() {
    var customListener = null;
    var props = {
        events: {
            rewardVideo: 1,
            interstitial: 2,
            fullScreenVideo: 3,
            contentAd: 4,
            contentView: 5,
            h5Ad: 6,
            wxMiniProgram: 7,
            novel: 8,
            newsAd: 9,
            newsView: 10,
            floatView: 11,
            taskAd: 12,
            taskView: 13,
        },
        actions: {
            onZjAdError: 1,
            onZjAdLoaded: 2,
            onZjAdShow: 3,
            onZjAdClick: 4,
            onZjAdVideoComplete: 5,
            onZjAdReward:6,
            onZjAdClose: 7,
            onPageEnter: 8,
            onPageLeave: 9,
            onZjAdEvent: 10,
            onReadTime: 11,
        },
        ready: function(e) {
            window.zjJSBridge = props
            e()
        },
        onEvent: function(event, data) {
            if ("function" === typeof customListener) {
                customListener(event, JSON.parse(data))
            }
        },
        removeListener: function() {
            customListener = null
            call(-1, {}, null)
        },
        setListener: function(listener) {
            if ("function" == typeof listener) {
                customListener = listener
                call(0, {}, null)
            }
        },
        rewardVideo: function(params, ret) {
            call(this.events.rewardVideo, params, ret)
        },
        interstitial: function(params, ret) {
            call(this.events.interstitial, params, ret)
        },
        fullScreenVideo: function(params, ret) {
            call(this.events.fullScreenVideo, params, ret)
        },
        contentAd: function(params, ret) {
            call(this.events.contentAd, params, ret)
        },
        contentView: function(params, ret) {
            call(this.events.contentView, params, ret)
        },
        h5Ad: function(params, ret) {
            call(this.events.h5Ad, params, ret)
        },
        wxMiniProgram: function(params, ret) {
            call(this.events.wxMiniProgram, params, ret)
        },
        novel: function(params, ret) {
            call(this.events.novel, params, ret)
        },
        newsAd: function(params, ret) {
            call(this.events.newsAd, params, ret)
        },
        newsView: function(params, ret) {
            call(this.events.newsView, params, ret)
        },
        floatView: function(params, ret) {
            call(this.events.floatView, params, ret)
        },
        taskAd: function(params, ret) {
            call(this.events.taskAd, params, ret)
        },
        taskView: function(params, ret) {
            call(this.events.taskView, params, ret)
        },
    }
    function call(method, params, callback) {
        let ret = ZJJSBridge.invoke(method, JSON.stringify(params))
        if (callback && "function" == typeof callback) {
            var isSuccess = ret == 0;
            callback(isSuccess, getReason(ret))
        }
    }
    function getReason(code) {
        switch (code) {
            case 0:
                return null
            case 1:
                return "SDK初始化错误，没有注册AdLoader"
            case 2:
                return "方法不支持"
            case 3:
                return "缺少关键参数"
            case 4:
                return "广告位ID为空"
            case 5:
                return "当前广告类型，用户ID不能为空"
            case 6:
                return "当前Activity不是FragmentActivity"
            case 7:
                return "隐藏或移除对象失败，对象为空或已移除"
            case 9:
                return "反射调用出错，请查看logcat"
            case 10:
                return "方法执行时出错"
            default:
                return "未知错误码" + code
        }
    }
    function version() {
        return ("object" == typeof ZJJSBridge) ? ZJJSBridge.sdkVersion() : (console.error("请在APP环境内调试广告"), "env error")
    }
    Object.defineProperty(props, "sdkVersion", {
        configurable: false,
        writable: false,
        value: version()
    })
    return props.ready(function() {}),
        props
}();
//export default zjJSBridge;